-- Copypasted from the ScreenGameplay variant,
-- except this version can update its segments if needed.
-- TODO: actually add stated functionality.
-- note: if the SongProgress in gameplay changes appearance, change this one accordingly

--local meterWidth = _screen.cx / 1.2
local meterWidth = 306-40
local songLabels

local function SetUpLabels()
	local song = GAMESTATE:GetCurrentSong()
	if not song then return end
	return song:GetTimingData():GetLabels(true)
end

local function CheckLabelParity()
	local song = GAMESTATE:GetCurrentSong()
	if not song then return end
	local compare = SetUpLabels()
	return songLabels == compare
end

local function CreateFrameWithBarParts()
	local ret = Def.ActorFrame{
		Name = "LabelHolder",
		OnCommand=function(self)
			self:skewx(0.45)
		end
	}
	
	-- Set up the labels here.
	songLabels = SetUpLabels()
	
	for i, labTab in ipairs(songLabels) do
		local songLengthBeats = GAMESTATE:GetCurrentSong():GetTimingData():GetBeatFromElapsedTime(GAMESTATE:GetCurrentSong():MusicLengthSeconds())
		local labelLength = i == #songLabels and songLengthBeats - labTab[1] or songLabels[i+1][1] - labTab[1]
		local quadLength = scale(labelLength, 0, songLengthBeats, 0, meterWidth)
		local quadX = scale(labTab[1], 0, songLengthBeats, -meterWidth/2, meterWidth/2)
		
		local theLabel = labTab[2]
		
		ret[#ret+1] = Def.Quad{
			Name = tostring(i),
			OnCommand=function(self)
				self:horizalign(left):x(quadX):zoomto(quadLength,16):diffuse(SongLabelColor(theLabel)):diffuserightedge(lerp_color(0.4, SongLabelColor(theLabel), Color.Black))
			end
		}
	end
	
	return ret
end

local lastLabel = 0

local function UpdateMe(self, deltaTime)
	local curPos = GAMESTATE:GetSongPosition():GetSongBeat()
	local songLengthBeats = GAMESTATE:GetCurrentSong():GetTimingData():GetBeatFromElapsedTime(GAMESTATE:GetCurrentSong():MusicLengthSeconds())
	local progBarPosition = scale(curPos, 0, songLengthBeats, -meterWidth/2, meterWidth/2)
	
	self:GetChild("Progress"):x( clamp(progBarPosition, -meterWidth/2, meterWidth/2) )
	
	-- let's try and not blow anything up
	if not songLabels then return end
	
	local labelIndex
	
	for i, labTab in ipairs(songLabels) do
		-- 
		if curPos < labTab[1] then
			labelIndex = i == 1 and i or i-1
			break
		end
		-- End of song?
		labelIndex = i
	end
	
	-- Re-use hardcore maths!
	local theCount = labelIndex == #songLabels and 9999 or songLabels[labelIndex+1][1] - songLabels[labelIndex][1]
	local theActualCount = math.ceil(theCount - (curPos - songLabels[labelIndex][1]) )
	self:GetChild("BeatCount"):settext( tostring(theActualCount) )
	if theActualCount < 5 then
		self:GetChild("BeatCount"):visible(true)
	else
		self:GetChild("BeatCount"):visible(false)
	end
	
	if #songLabels == 1 then 
		self:GetChild("Segment"):settext( SecondsToMSS(GAMESTATE:GetSongPosition():GetMusicSecondsVisible()) )
	elseif labelIndex ~= lastLabel then
		lastLabel = labelIndex
		local theLabel = songLabels[labelIndex][2]
		
		self:GetChild("Segment"):settext(SongLabelString(theLabel, true)):diffuse(ColorBlend(SongLabelColor(theLabel), Color.White))
		if string.lower(string.gsub(theLabel, "%A", "")) == "freestyle" then
			self:GetChild("Segment"):glowblink():effectcolor1(Color.Stealth):effectcolor2(Color.White):
				effecttiming(0.1,0.1,0.1,0.1,0.6):effectclock("bgm")
		else
			self:GetChild("Segment"):stopeffect()
		end
	end
end

local t = Def.ActorFrame{
	OnCommand=function(self)
		self:SetUpdateFunction(UpdateMe)
	end,
	PlayingCommand=function(self)
		--SM(CheckLabelParity())
	end,
	
	-- Frame/base for all the progress bar stuff to go on.
	LoadActor("bprogress") .. {
		OnCommand=function(self)
			self:x(-4):zoomx(GAMESTATE:GetMasterPlayerNumber() == PLAYER_1 and 1 or -1)
		end
	},
	
	-- *Finally* call that function that's taken up over half of this file
	CreateFrameWithBarParts(),
	-- Progress marker!
	LoadActor("blip") .. {
		Name = "Progress",
		OnCommand=function(self)
			self:zoomto(6,26):diffuse(Color.White):skewx(0.7)
		end
	},
	
	Def.BitmapText{
		Font = "Common Normal",
		Name = "Segment",
		Text = "hi :)",
		OnCommand=function(self)
			self:y(25):zoom(0.6):strokecolor(Color.Black):maxwidth(meterWidth/0.6)
		end
	},
	Def.BitmapText{
		Font = "Common Normal",
		Name = "BeatCount",
		Text = ":)",
		OnCommand=function(self)
			self:horizalign(right):xy(meterWidth/2,26):zoom(0.6):strokecolor(Color.Black):heartbeat():effectclock('beatnooffset')
		end
	}
}

return t
